IF OBJECT_ID('p_plug_Farma_tipoRegistro_vinteEDois') IS NOT NULL
	BEGIN
		DROP PROCEDURE p_plug_Farma_tipoRegistro_vinteEDois
	END
 
GO 
CREATE PROCEDURE [dbo].[p_plug_Farma_tipoRegistro_vinteEDois] (@filial INT , @data   DATE , @cd_emp INT  = 1) AS
BEGIN

	SELECT '22' as tipoRegistro,
		   ISNULL(REPLACE(CONVERT(VARCHAR(10), m.dt_cad, 103), '/', ''),'') as dataCaptacao,
		   FORMAT(m.dt_cad, 'HHmmss') as horarioCaptacao,
		   ISNULL(REPLACE(CONVERT(VARCHAR(10), ISNULL(m.DT_RECEITA,GETDATE()), 103), '/', ''),'') as dataReceita,
		   ISNULL(BAR.CD_BARRA,'') AS codigoBarrasProduto,
		   M.QT_PROD AS quantidadePrescrita,
		   m.cd_medico_rec  AS numeroRegistroPrescritor,
		   ISNULL(M.NR_RECEITA, 0) AS numeroReceita,
		   FUNC.cd_fun as numeroRegistroColaborador,
		   '' as numeroNota,
		   '' as tipoNotaVenda,
		   '' as serieNota,
		   '' as codigoBarrasProdutoVendido,
		   '' as quantidadeProdutoVendido
	FROM EST_ORC_GLB_MEDICO M
	INNER JOIN glb_medicos MEDICO ON MEDICO.cd_emp = m.cd_emp
											  AND MEDICO.cd_ctr = m.cd_medico_rec
	INNER JOIN fp_func FUNC ON FUNC.cd_fun = m.cd_vend
	CROSS APPLY (SELECT TOP 1 BAR.CD_BARRA
				FROM EST_PROD_CD_BARRA BAR
				WHERE BAR.CD_PROD = M.CD_PROD
				and bar.cd_emp = m.cd_emp) BAR
	INNER JOIN EST_PROD P ON P.CD_PROD = M.CD_PROD
	WHERE CONVERT(DATE,M.DT_CAD) = @data
	and m.cd_filial = @filial
	and m.cd_emp = @cd_emp
	AND P.FLAG_PRODUTO_CONTROLADO = 0
	
	
END